/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.conf;

import com.intellij.json.psi.JsonValue;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JsonTag<V extends JsonValue> {
    private final String path;
    private final Class<V> valueType;
    private final Class<? extends JsonValue> arrayItemType;

    public JsonTag(String path, Class<V> valueType, Class<? extends JsonValue> arrayItemType) {
        this.path = path;
        this.valueType = valueType;
        this.arrayItemType = arrayItemType;
    }

    @NotNull
    public List<String> getPathAsList() {
        List<String> list = Arrays.stream(this.path().split("\\.")).collect(Collectors.toList());
        if (list == null) {
            JsonTag.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public String getName() {
        List<String> pathAsList = this.getPathAsList();
        String string = pathAsList.get(pathAsList.size() - 1);
        if (string == null) {
            JsonTag.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String path() {
        return this.path;
    }

    public Class<V> valueType() {
        return this.valueType;
    }

    public Class<? extends JsonValue> arrayItemType() {
        return this.arrayItemType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        JsonTag that = (JsonTag)obj;
        return Objects.equals(this.path, that.path) && Objects.equals(this.valueType, that.valueType) && Objects.equals(this.arrayItemType, that.arrayItemType);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.valueType, this.arrayItemType);
    }

    public String toString() {
        return "JsonTag[path=" + this.path + ", valueType=" + String.valueOf(this.valueType) + ", arrayItemType=" + String.valueOf(this.arrayItemType) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/cxbox/intellij/community/common/conf/JsonTag";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathAsList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

