/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.conf;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.conf.JsonTag;
import org.cxbox.intellij.community.common.util.Common;
import org.cxbox.intellij.community.common.util.JsonElementGenerator;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.injection.SimpleLangToMetaFilesValueInjector;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.cxbox.intellij.community.screen.view.ViewNameReferenceContributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JView {
    public static final String NO_LEADING_DOT_VIEW_JSON = "view.json";
    public static final String VIEW_JSON = ".view.json";
    public static final JsonTag<JsonStringLiteral> NAME = new JsonTag<JsonStringLiteral>("name", JsonStringLiteral.class, null);
    public static final PsiElementPattern.Capture<JsonValue> VIEW_NAME_REF_PATTERN = Common.createPropertyValuePattern(NAME.getName(), ".view.json");
    public static final JsonTag<JsonStringLiteral> TITLE = new JsonTag<JsonStringLiteral>("title", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> URL = new JsonTag<JsonStringLiteral>("url", JsonStringLiteral.class, null);
    public static final JsonTag<JsonArray> WIDGETS = new JsonTag<JsonArray>("widgets", JsonArray.class, JsonObject.class);
    public static final JsonTag<JsonStringLiteral> WIDGETS_WIDGET_NAME = new JsonTag<JsonStringLiteral>("widgets.widgetName", JsonStringLiteral.class, null);
    public static final JsonTag<JsonNumberLiteral> WIDGETS_WIDGET_POSITION = new JsonTag<JsonNumberLiteral>("widgets.position", JsonNumberLiteral.class, null);

    public static String getName(@Nullable JsonFile file) {
        JsonObject topLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral type = JsonFacade.safeGetPropertyValueOfType(topLevelObject, NAME);
        return JsonFacade.safeGetValueAsString((PsiElement)type);
    }

    public static String getTitle(@Nullable JsonFile file) {
        JsonObject topLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral type = JsonFacade.safeGetPropertyValueOfType(topLevelObject, TITLE);
        return JsonFacade.safeGetValueAsString((PsiElement)type);
    }

    public static SimpleNamedElement getInjectedName(@Nullable JsonFile file) {
        if (file == null) {
            return null;
        }
        JsonObject widgetTopLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral name = JsonFacade.safeGetPropertyValueOfType(widgetTopLevelObject, NAME);
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        return JView.getViewFileInjectedName(project, module, name);
    }

    public static void setUrlViewIfChanged(JsonFile jsonFile, String newValue) {
        String[] split;
        String propName = URL.getName();
        if (!JsonStringLiteral.class.isAssignableFrom(URL.valueType())) {
            return;
        }
        String url = JView.getUrl(jsonFile);
        if (url != null && (split = url.split("view")).length == 2 && !Objects.equals(split[1], newValue)) {
            JsonFacade.safeSetTopLevelPropertyIfChanged(jsonFile, propName, split[0] + "view/" + newValue);
        }
    }

    public static void setNameTagIfChanged(JsonFile jsonFile, String newValue) {
        String propName = NAME.getName();
        if (!JsonStringLiteral.class.isAssignableFrom(NAME.valueType())) {
            return;
        }
        JsonFacade.safeSetTopLevelPropertyIfChanged(jsonFile, propName, newValue);
    }

    public static String getUrl(@Nullable JsonFile file) {
        JsonObject topLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral type = JsonFacade.safeGetPropertyValueOfType(topLevelObject, URL);
        return JsonFacade.safeGetValueAsString((PsiElement)type);
    }

    public static List<ViewLookupItem> getAllInjectedViewNames(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            JView.$$$reportNull$$$0(0);
        }
        if (module == null) {
            JView.$$$reportNull$$$0(1);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (List)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(JView.getAllInjectedViewNamesNoCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    private static List<ViewLookupItem> getAllInjectedViewNamesNoCache(@NotNull Module module) {
        if (module == null) {
            JView.$$$reportNull$$$0(2);
        }
        @NotNull Project project = module.getProject();
        GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        List<JsonFile> allViewFiles = JView.getAllViewFiles(scp, project, module);
        return allViewFiles.stream().map(file -> {
            JsonObject topLevelObject = JsonFacade.getTopLevelObject(file);
            JsonStringLiteral name = JsonFacade.safeGetPropertyValueOfType(topLevelObject, NAME);
            SimpleNamedElement viewFileInjectedName = JView.getViewFileInjectedName(project, module, name);
            if (viewFileInjectedName == null) {
                return null;
            }
            ViewLookupItem viewLookupItem = new ViewLookupItem((PsiNamedElement)viewFileInjectedName);
            viewLookupItem.title = JView.getTitle(file);
            return viewLookupItem;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public static Pair<Optional<? extends PsiNamedElement>, List<ViewLookupItem>> getLinkAndAutocompletionByViewNameAndScreen(@NotNull String value, @NotNull JsonFile screenFile, @NotNull Project project, @NotNull Module module) {
        if (value == null) {
            JView.$$$reportNull$$$0(3);
        }
        if (screenFile == null) {
            JView.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JView.$$$reportNull$$$0(5);
        }
        if (module == null) {
            JView.$$$reportNull$$$0(6);
        }
        Pair<Optional<? extends PsiNamedElement>, List<ViewLookupItem>> linkAndAutocompletionByViewName = JView.getLinkAndAutocompletionByViewName(value, project, module);
        List<JsonStringLiteral> screenViews = JView.getScreenViews(screenFile);
        List<ViewLookupItem> autocomplete = ((List)linkAndAutocompletionByViewName.getSecond()).stream().filter(Objects::nonNull).filter(e -> screenViews.stream().anyMatch(screenView -> Objects.equals(e.injectedNamedElement.getName(), JsonFacade.safeGetValueAsString((PsiElement)screenView)))).toList();
        Optional<PsiNamedElement> link = ((Optional)linkAndAutocompletionByViewName.getFirst()).map(e -> {
            if (e.getName() != null && screenViews.stream().anyMatch(screenView -> e.getName().equals(JsonFacade.safeGetValueAsString((PsiElement)screenView)))) {
                return e;
            }
            return null;
        });
        Pair pair = Pair.pair(link, autocomplete);
        if (pair == null) {
            JView.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @NotNull
    private static List<JsonStringLiteral> getScreenViews(@NotNull JsonFile screenFile) {
        if (screenFile == null) {
            JView.$$$reportNull$$$0(8);
        }
        ArrayList<JsonStringLiteral> screenViews = new ArrayList<JsonStringLiteral>();
        PsiTreeUtil.processElements((PsiElement)screenFile, e -> {
            if (ViewNameReferenceContributor.Holder.SCREEN_VIEW_NAME_PATTERN.accepts((Object)e) && e instanceof JsonStringLiteral) {
                JsonStringLiteral liE = (JsonStringLiteral)e;
                screenViews.add(liE);
            }
            return true;
        });
        ArrayList<JsonStringLiteral> arrayList = screenViews;
        if (arrayList == null) {
            JView.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static Pair<Optional<? extends PsiNamedElement>, List<ViewLookupItem>> getLinkAndAutocompletionByViewName(@NotNull String value, @NotNull Project project, @NotNull Module module) {
        if (value == null) {
            JView.$$$reportNull$$$0(10);
        }
        if (project == null) {
            JView.$$$reportNull$$$0(11);
        }
        if (module == null) {
            JView.$$$reportNull$$$0(12);
        }
        List<ViewLookupItem> allInjectedViewNames = JView.getAllInjectedViewNames(project, module);
        Optional<PsiNamedElement> link = allInjectedViewNames.stream().filter(e -> Objects.equals(value, e.injectedNamedElement.getName())).map(e -> e.injectedNamedElement).findFirst();
        ArrayList<ViewLookupItem> autocomplete = new ArrayList<ViewLookupItem>(allInjectedViewNames);
        Pair pair = Pair.pair(link, autocomplete);
        if (pair == null) {
            JView.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @NotNull
    public static Optional<Double> getViewWidgetPosition(@NotNull JsonObject el) {
        if (el == null) {
            JView.$$$reportNull$$$0(14);
        }
        Optional<Double> optional = Optional.ofNullable(JsonFacade.safeGetValueAsDouble((PsiElement)JsonFacade.safeGetPropertyValueOfType(el, WIDGETS_WIDGET_POSITION)));
        if (optional == null) {
            JView.$$$reportNull$$$0(15);
        }
        return optional;
    }

    public static Pair<JsonArray, List<JsonObject>> getAllViewWidgets(JsonFile jsonFile) {
        JsonObject topLevelValue = JsonFacade.getTopLevelObject(jsonFile);
        JsonArray widgets = JsonFacade.safeGetPropertyValueOfType(topLevelValue, WIDGETS);
        List<JsonValue> widgetsItems = JsonFacade.getChildrenOfTypeAsList((PsiElement)widgets, WIDGETS.arrayItemType());
        return new Pair((Object)widgets, widgetsItems);
    }

    @NotNull
    public static List<JsonFile> getAllViewFiles(@NotNull GlobalSearchScope scp, @NotNull Project project, @NotNull Module module) {
        if (scp == null) {
            JView.$$$reportNull$$$0(16);
        }
        if (project == null) {
            JView.$$$reportNull$$$0(17);
        }
        if (module == null) {
            JView.$$$reportNull$$$0(18);
        }
        List<JsonFile> list = JView.getAllViews(project, module).stream().map(vf -> PsiManager.getInstance((Project)project).findFile(vf)).map(JsonFile.class::cast).collect(Collectors.toList());
        if (list == null) {
            JView.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    public static SimpleNamedElement getViewFileInjectedName(@NotNull Project project, @NotNull Module module, @Nullable JsonStringLiteral nameInViewFile) {
        if (project == null) {
            JView.$$$reportNull$$$0(20);
        }
        if (module == null) {
            JView.$$$reportNull$$$0(21);
        }
        return SimpleLangToMetaFilesValueInjector.getInjectedName(project, module, (JsonValue)nameInViewFile);
    }

    public static void addWidgetToView(@NotNull String widgetName, @NotNull JsonFile viewFile) {
        if (widgetName == null) {
            JView.$$$reportNull$$$0(22);
        }
        if (viewFile == null) {
            JView.$$$reportNull$$$0(23);
        }
        Project project = viewFile.getProject();
        JsonArray rows = JsonFacade.safeGetPropertyValueOfType(JsonFacade.getTopLevelObject(viewFile), WIDGETS);
        String newRowValue = " \n      \"widgetName\": \"" + widgetName + "\",\n      \"position\": 2,\n      \"gridWidth\": 24\n    ";
        JsonElementGenerator json = new JsonElementGenerator(project);
        JsonObject newRowObject = json.createObject(newRowValue);
        JsonArray rowsValue = json.createArrayOfObjects(List.of(newRowObject.getText()));
        if (rows != null) {
            if (!rows.getValueList().isEmpty()) {
                rows.addBefore((PsiElement)newRowObject, (PsiElement)rows.getValueList().get(0));
                rows.addAfter(json.createComma(), (PsiElement)rows.getValueList().get(0));
            } else {
                rows.replace((PsiElement)rowsValue);
            }
        }
    }

    @NotNull
    public static List<Result> getAllViewsByWidgetInjectedNameAndAllWidgetsThatHaveBc(@NotNull String bc, @NotNull Project project, @NotNull Module module, @NotNull PsiElement widgetFileInjectedName) {
        if (bc == null) {
            JView.$$$reportNull$$$0(24);
        }
        if (project == null) {
            JView.$$$reportNull$$$0(25);
        }
        if (module == null) {
            JView.$$$reportNull$$$0(26);
        }
        if (widgetFileInjectedName == null) {
            JView.$$$reportNull$$$0(27);
        }
        List<ImmutablePair<JsonFile, PsiElement>> viewFilesThatWidgetReferences = JView.getAllViewsByWidgetName(project, module, widgetFileInjectedName);
        return JView.getViewToAllWidgetsInThisViewThatHaveBc(viewFilesThatWidgetReferences, bc, project, module);
    }

    public static Collection<VirtualFile> getAllViews(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            JView.$$$reportNull$$$0(28);
        }
        if (module == null) {
            JView.$$$reportNull$$$0(29);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (Collection)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(JView.getAllViewsNoCache(module), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    private static Collection<VirtualFile> getAllViewsNoCache(@NotNull Module module) {
        if (module == null) {
            JView.$$$reportNull$$$0(30);
        }
        @NotNull Project project = module.getProject();
        GlobalSearchScope scope = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        return FilenameIndex.getAllFilesByExt((Project)project, (String)NO_LEADING_DOT_VIEW_JSON, (GlobalSearchScope)scope);
    }

    public static boolean referenceExistsByWidgetName(@NotNull Project project, @NotNull Module module, @Nullable PsiElement widgetFileInjectedName) {
        if (project == null) {
            JView.$$$reportNull$$$0(31);
        }
        if (module == null) {
            JView.$$$reportNull$$$0(32);
        }
        if (widgetFileInjectedName == null) {
            return false;
        }
        GlobalSearchScope scope = GlobalSearchScope.filesWithoutLibrariesScope((Project)project, JView.getAllViews(project, module));
        Query searchAllViewsReferencingWidgetFileInjectedName = ReferencesSearch.search((PsiElement)widgetFileInjectedName, (SearchScope)scope, (boolean)true);
        PsiReference first = (PsiReference)searchAllViewsReferencingWidgetFileInjectedName.findFirst();
        return first != null;
    }

    @NotNull
    public static List<ImmutablePair<JsonFile, PsiElement>> getAllViewsByWidgetName(@NotNull Project project, @NotNull Module module, @Nullable PsiElement widgetFileInjectedName) {
        if (project == null) {
            JView.$$$reportNull$$$0(33);
        }
        if (module == null) {
            JView.$$$reportNull$$$0(34);
        }
        if (widgetFileInjectedName == null) {
            return new ArrayList<ImmutablePair<JsonFile, PsiElement>>();
        }
        Collection<VirtualFile> allViewFiles = JView.getAllViews(project, module);
        GlobalSearchScope allViewfilesWithLibrariesScope = GlobalSearchScope.filesWithoutLibrariesScope((Project)project, allViewFiles);
        Query searchAllViewsReferencingWidgetFileInjectedName = ReferencesSearch.search((PsiElement)widgetFileInjectedName, (SearchScope)allViewfilesWithLibrariesScope, (boolean)true);
        List<ImmutablePair<JsonFile, PsiElement>> list = searchAllViewsReferencingWidgetFileInjectedName.findAll().stream().map(PsiReference::getElement).map(e -> new ImmutablePair((Object)((JsonFile)e.getContainingFile()), e)).collect(Collectors.toList());
        if (list == null) {
            JView.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public static List<Result> getViewToAllWidgetsInThisViewThatHaveBc(@NotNull List<ImmutablePair<JsonFile, PsiElement>> viewFiles, @NotNull String bc, @NotNull Project project, @NotNull Module module) {
        if (viewFiles == null) {
            JView.$$$reportNull$$$0(36);
        }
        if (bc == null) {
            JView.$$$reportNull$$$0(37);
        }
        if (project == null) {
            JView.$$$reportNull$$$0(38);
        }
        if (module == null) {
            JView.$$$reportNull$$$0(39);
        }
        List<Result> list = viewFiles.stream().map(viewFileThatWidgetReferences -> {
            JsonArray viewFileWidgetsArray = JsonFacade.safeGetPropertyValueOfType(JsonFacade.getTopLevelObject((JsonFile)viewFileThatWidgetReferences.getLeft()), WIDGETS);
            List<JsonValue> viewFileWidgetsObjects = JsonFacade.getChildrenOfTypeAsList((PsiElement)viewFileWidgetsArray, WIDGETS.arrayItemType());
            List<JsonStringLiteral> viewFileWidgetsNames = viewFileWidgetsObjects.stream().map(viewWidgetsObject -> JsonFacade.safeGetPropertyValueOfType(viewWidgetsObject, WIDGETS_WIDGET_NAME)).toList();
            List<PsiLanguageInjectionHost> widgetFileWidgetNames = viewFileWidgetsNames.stream().filter(Objects::nonNull).map(widgetName -> ((Optional)JWidget.getLinkAndAutocompletionByWidgetName(JsonFacade.getValue(widgetName), project, module).getFirst()).map(link -> InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)link)).orElse(null)).toList();
            List<PsiElement> widgetFileWidgetNamesWithBcEqualToBc = widgetFileWidgetNames.stream().filter(Objects::nonNull).filter(widgetNameInWidgetFile -> {
                JsonStringLiteral liWidgetFileBc;
                JsonFile widgetFile = (JsonFile)widgetNameInWidgetFile.getContainingFile();
                JsonObject widgetFileTopLevelObject = JsonFacade.getTopLevelObject(widgetFile);
                JsonValue widgetFileBc = (JsonValue)JsonFacade.safeGetPropertyValueOfType(widgetFileTopLevelObject, JWidget.BC);
                return widgetFileBc instanceof JsonStringLiteral && Objects.equals(bc, JsonFacade.getValue(liWidgetFileBc = (JsonStringLiteral)widgetFileBc));
            }).toList();
            Map<String, JsonStringLiteral> viewFileWidgetsNamesStringToPsiMap = viewFileWidgetsNames.stream().filter(Objects::nonNull).collect(Collectors.toMap(JsonFacade::getValue, viewWidgetsName -> viewWidgetsName, (e1, e2) -> e1));
            List result = widgetFileWidgetNamesWithBcEqualToBc.stream().filter(Objects::nonNull).map(widgetFileWidgetNameWithBcEqualToBc -> {
                PsiElement psiElement;
                if (widgetFileWidgetNameWithBcEqualToBc instanceof JsonStringLiteral) {
                    JsonStringLiteral li = (JsonStringLiteral)widgetFileWidgetNameWithBcEqualToBc;
                    psiElement = viewFileWidgetsNamesStringToPsiMap.getOrDefault(JsonFacade.getValue(li), null);
                } else {
                    psiElement = null;
                }
                return psiElement;
            }).collect(Collectors.toList());
            return new Result((JsonFile)viewFileThatWidgetReferences.getLeft(), result);
        }).collect(Collectors.toList());
        if (list == null) {
            JView.$$$reportNull$$$0(40);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 13, 15, 19, 35, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 12: 
            case 18: 
            case 21: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenFile";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/conf/JView";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scp";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widgetName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFile";
                break;
            }
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bc";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widgetFileInjectedName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/conf/JView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkAndAutocompletionByViewNameAndScreen";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenViews";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkAndAutocompletionByViewName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewWidgetPosition";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllViewFiles";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllViewsByWidgetName";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewToAllWidgetsInThisViewThatHaveBc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllInjectedViewNames";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllInjectedViewNamesNoCache";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLinkAndAutocompletionByViewNameAndScreen";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 35: 
            case 40: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScreenViews";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLinkAndAutocompletionByViewName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getViewWidgetPosition";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllViewFiles";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getViewFileInjectedName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addWidgetToView";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAllViewsByWidgetInjectedNameAndAllWidgetsThatHaveBc";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAllViews";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAllViewsNoCache";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "referenceExistsByWidgetName";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAllViewsByWidgetName";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getViewToAllWidgetsInThisViewThatHaveBc";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 13, 15, 19, 35, 40 -> new IllegalStateException(string);
        };
    }

    public record Result(JsonFile view, List<? extends PsiElement> widgetNames) {
        private final JsonFile view;
        private final List<? extends PsiElement> widgetNames;

        public Result(@NotNull JsonFile view, @NotNull List<? extends PsiElement> widgetNames) {
            if (view == null) {
                Result.$$$reportNull$$$0(0);
            }
            if (widgetNames == null) {
                Result.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public JsonFile view() {
            JsonFile jsonFile = this.view;
            if (jsonFile == null) {
                Result.$$$reportNull$$$0(2);
            }
            return jsonFile;
        }

        @NotNull
        public List<? extends PsiElement> widgetNames() {
            List<? extends PsiElement> list = this.widgetNames;
            if (list == null) {
                Result.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "widgetNames";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/common/conf/JView$Result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/common/conf/JView$Result";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "view";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "widgetNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class ViewLookupItem {
        @NotNull
        public final PsiNamedElement injectedNamedElement;
        public String title;

        public ViewLookupItem(@NotNull PsiNamedElement injectedNamedElement) {
            if (injectedNamedElement == null) {
                ViewLookupItem.$$$reportNull$$$0(0);
            }
            this.injectedNamedElement = injectedNamedElement;
        }

        public LookupElement mapToLookupElement() {
            return LookupElementBuilder.create((PsiNamedElement)this.injectedNamedElement).withIcon(AllIcons.FileTypes.Json).withTypeText("title: " + this.title);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedNamedElement", "org/cxbox/intellij/community/common/conf/JView$ViewLookupItem", "<init>"));
        }
    }
}

