/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.language;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cxbox.intellij.community.language.SimpleFile;
import org.cxbox.intellij.community.language.SimpleFileType;
import org.cxbox.intellij.community.language.psi.SimpleProperty;

public class SimpleUtil {
    public static List<SimpleProperty> findProperties(Project project, String key) {
        ArrayList<SimpleProperty> result = new ArrayList<SimpleProperty>();
        Collection virtualFiles = FileTypeIndex.getFiles((FileType)SimpleFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        for (VirtualFile virtualFile : virtualFiles) {
            SimpleProperty[] properties;
            SimpleFile simpleFile = (SimpleFile)PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (simpleFile == null || (properties = (SimpleProperty[])PsiTreeUtil.getChildrenOfType((PsiElement)simpleFile, SimpleProperty.class)) == null) continue;
            for (SimpleProperty property : properties) {
                if (!key.equals(property.getKey())) continue;
                result.add(property);
            }
        }
        return result;
    }

    public static List<SimpleProperty> findProperties(Project project) {
        ArrayList<SimpleProperty> result = new ArrayList<SimpleProperty>();
        Collection virtualFiles = FileTypeIndex.getFiles((FileType)SimpleFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        for (VirtualFile virtualFile : virtualFiles) {
            SimpleProperty[] properties;
            SimpleFile simpleFile = (SimpleFile)PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (simpleFile == null || (properties = (SimpleProperty[])PsiTreeUtil.getChildrenOfType((PsiElement)simpleFile, SimpleProperty.class)) == null) continue;
            Collections.addAll(result, properties);
        }
        return result;
    }
}

