/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.FieldMetaBuilderUtil;

public class FeatureAvailabilityUtil {
    private FeatureAvailabilityUtil() {
    }

    public static boolean isPlatformInScope(PsiFile file) {
        Module moduleForPsiElement = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return moduleForPsiElement != null && Cache.getPlatformRootPackageWithoutDotOrElseNull(file.getProject(), moduleForPsiElement) != null;
    }

    public static boolean isLambdaActionBuilderAvailable(PsiFile file) {
        Module moduleForPsiElement = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return moduleForPsiElement != null && FieldMetaBuilderUtil.getActionsBuilderActionWithLambda(file.getProject(), moduleForPsiElement) != null;
    }

    public static boolean isLambdaActionBuilderAvailable(Project prj, Module module) {
        return module != null && FieldMetaBuilderUtil.getActionsBuilderActionWithLambda(prj, module) != null;
    }
}

