/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.screen.primaryAndDefaultViewName.primaryViewName;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Optional;
import org.cxbox.intellij.community.common.conf.JScreen;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NotNull;

public final class PrimaryViewNameInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "PrimaryViewNameInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Optional link;
        if (file == null) {
            PrimaryViewNameInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PrimaryViewNameInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile screenFile = (JsonFile)file;
        if (!file.getName().endsWith("screen.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonStringLiteral primaryViewName = JsonFacade.safeGetPropertyValueOfType(JsonFacade.getTopLevelObject(screenFile), JScreen.PRIMARY_VIEW_NAME);
        SmartList descriptors = new SmartList();
        String primaryViewNameString = JsonFacade.safeGetValueAsString((PsiElement)primaryViewName);
        if (primaryViewNameString != null && (link = (Optional)JView.getLinkAndAutocompletionByViewNameAndScreen(primaryViewNameString, screenFile, project, module).getFirst()).isEmpty()) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)primaryViewName, new TextRange(1, primaryViewName.getValue().length() + 1), "Incorrect value - value must be declared in navigation/../viewName and must reference to existing .view.json. Use autocomplete to provide correct value", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[]{new Fix()}));
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/screen/primaryAndDefaultViewName/primaryViewName/PrimaryViewNameInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Fix
    implements LocalQuickFix {
        private Fix() {
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Select correct value";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Select correct value";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            QuickFixUtils.clearJsonStringLiteralValueAndInvokeAutoCompliteIfPossible(project, descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/screen/primaryAndDefaultViewName/primaryViewName/PrimaryViewNameInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

