/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.searchParameter.reference.commentEntityName;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullyNameInCommentInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static String getCommentFromMultiComment(String commentText) {
        if (!commentText.contains("//@entity:") && !commentText.contains("@entity:")) {
            return null;
        }
        if (commentText.startsWith("//@entity:")) {
            return commentText.replaceAll("//@entity:", "").trim();
        }
        String comment = commentText.trim();
        if (comment.contains("\n//@entity:")) {
            comment = comment.substring(comment.indexOf("\n//@entity:") + 1);
            comment = comment.substring(0, comment.indexOf("\n"));
        } else if (comment.contains("\n@entity:")) {
            comment = comment.substring(comment.indexOf("\n@entity:") + 1);
            comment = comment.substring(0, comment.indexOf("\n"));
        }
        if (comment.startsWith("//@entity:")) {
            return comment.replaceAll("//@entity:", "").trim();
        }
        if (comment.startsWith("@entity:")) {
            return comment.replaceAll("@entity:", "").trim();
        }
        return null;
    }

    @Nullable
    public static PsiClass getClassByName(Project project, String className) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        return className == null ? null : javaPsiFacade.findClass(className, GlobalSearchScope.allScope((Project)project));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FullyNameInCommentInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitComment(@NotNull PsiComment comment) {
                PsiClass psiClass;
                if (comment == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitComment(comment);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)comment);
                if (module == null) {
                    return;
                }
                String commentText = FullyNameInCommentInspection.getCommentFromMultiComment(comment.getText());
                if (commentText != null && (psiClass = FullyNameInCommentInspection.getClassByName(comment.getProject(), commentText)) == null) {
                    holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)comment, new TextRange(comment.getText().indexOf(commentText), comment.getText().indexOf(commentText) + commentText.length()), "Incorrect value. Add fully qualified path to entity. //@entity:", ProblemHighlightType.ERROR, true, new LocalQuickFix[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "org/cxbox/intellij/community/java/searchParameter/reference/commentEntityName/FullyNameInCommentInspection$1", "visitComment"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/cxbox/intellij/community/java/searchParameter/reference/commentEntityName/FullyNameInCommentInspection", "buildVisitor"));
    }

    public record Fix(PsiElement className) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Add fully qualified path to entity";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Add fully qualified path to entity";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)this.className.getProject());
            PsiComment newElement = factory.createCommentFromText("//@entity:fully qualified path to entity", this.className);
            this.className.addBefore((PsiElement)newElement, this.className.getChildren()[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/java/searchParameter/reference/commentEntityName/FullyNameInCommentInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

