/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.searchParameter.reference;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import java.util.Arrays;
import java.util.List;
import org.cxbox.intellij.community.common.util.PsiCommentUtil;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.java.searchParameter.reference.SearchParameterAnnotationReferenceContributor;
import org.cxbox.intellij.community.java.searchParameter.reference.SearchParameterAnnotationReferenceProvider;
import org.cxbox.intellij.community.java.searchParameter.reference.commentEntityName.FullyNameInCommentInspection;
import org.jetbrains.annotations.NotNull;

public class SearchParameterAnnotationReferenceInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SearchParameterAnnotationReferenceInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitLiteralExpression(element);
                if (!SearchParameterAnnotationReferenceContributor.Holder.DTO_SEARCH_PARAM_NAME_ATTR_PATTERN.accepts((Object)element)) {
                    return;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module == null) {
                    return;
                }
                PsiClass entityClass = SearchParameterAnnotationReferenceProvider.getEntityClass(element, module);
                if (entityClass == null && PsiCommentUtil.containCommitWithPrefixes((PsiElement)element, List.of("@entity:", "//@entity:"))) {
                    String fullyNameFromComment = PsiCommentUtil.getCommentWithPrefixesAndFullyName((PsiElement)element, List.of("@entity:", "//@entity:"));
                    entityClass = FullyNameInCommentInspection.getClassByName(element.getProject(), fullyNameFromComment);
                }
                PsiClass finalEntityClass = entityClass;
                Arrays.stream(element.getReferences()).filter(e -> {
                    SearchParameterAnnotationReferenceProvider.ReferenceLinkFromSearchParameter ref;
                    return e instanceof SearchParameterAnnotationReferenceProvider.ReferenceLinkFromSearchParameter && !(ref = (SearchParameterAnnotationReferenceProvider.ReferenceLinkFromSearchParameter)((Object)e)).isCorrectPathPart();
                }).forEach(ref -> {
                    ProblemHighlightType errorType = finalEntityClass == null ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : ProblemHighlightType.ERROR;
                    holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)element, ref.getRangeInElement(), "Incorrect value. Use autocomplete to provide correct one", errorType, true, new LocalQuickFix[]{new QuickFixUtils.ClearJavaPsiLiteralValueAndCallAutocompletionFix("Select value with autocompletion", (PsiElement)element)}));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationReferenceInspection$1", "visitLiteralExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationReferenceInspection", "buildVisitor"));
    }

    public record Fix(PsiElement className) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Add fully qualified path to entity";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Add fully qualified path to entity";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)this.className.getProject());
            PsiComment newElement = factory.createCommentFromText("//@entity:fully qualified path to entity", this.className);
            this.className.addBefore((PsiElement)newElement, this.className.getChildren()[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationReferenceInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

