/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.name;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.jetbrains.annotations.NotNull;

public final class WigdetIsNeverUsedInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "WigdetIsNeverUsedInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            WigdetIsNeverUsedInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            WigdetIsNeverUsedInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return null;
        }
        JsonFile widgetFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            return null;
        }
        String widgetType = JWidget.getWidgetType(widgetFile);
        JsonObject widgetFileTopLevelObject = JsonFacade.getTopLevelObject(widgetFile);
        JsonStringLiteral widgetName = JsonFacade.safeGetPropertyValueOfType(widgetFileTopLevelObject, JWidget.NAME);
        SmartList descriptors = new SmartList();
        if (!(widgetName == null || widgetType != null && List.of("SecondLevelMenu", "ThirdLevelMenu", "FourthLevelMenu").contains(widgetType))) {
            Project project = widgetFile.getProject();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)widgetFile);
            if (module == null) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            SimpleNamedElement widgetFileInjectedName = JWidget.getWidgetFileInjectedName(widgetFile);
            List<ImmutablePair<JsonFile, PsiElement>> result = JView.getAllViewsByWidgetName(project, module, (PsiElement)widgetFileInjectedName);
            if (result.isEmpty()) {
                descriptors.add(manager.createProblemDescriptor((PsiElement)widgetName, new TextRange(1, widgetName.getValue().length() + 1), "Widget is never used", ProblemHighlightType.LIKE_UNUSED_SYMBOL, true, new LocalQuickFix[]{new Fix(widgetName.getValue())}));
            }
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/wigdet/name/WigdetIsNeverUsedInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record Fix(String toBeDeletedWidgetName) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = "(2) Remove unused widget " + this.toBeDeletedWidgetName;
            if (string == null) {
                Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Not used";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PsiFile containingFile;
            VirtualFile virtualFile;
            if (project == null) {
                Fix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(2);
            }
            if ((virtualFile = (containingFile = (element = descriptor.getPsiElement()).getContainingFile()).getVirtualFile()) != null) {
                FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
                try {
                    WriteAction.run(() -> virtualFile.delete((Object)element));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
                if (editor != null) {
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument((Document)editor.getDocument());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/wigdet/name/WigdetIsNeverUsedInspection$Fix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/wigdet/name/WigdetIsNeverUsedInspection$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

