/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.screen.view;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.cxbox.intellij.community.action.RunTemplateAction;
import org.cxbox.intellij.community.action.RunTemplateAddBeforeFieldAction;
import org.cxbox.intellij.community.common.conf.JScreen;
import org.cxbox.intellij.community.common.lineMarker.RunLineMarkerInfo;
import org.cxbox.intellij.community.common.util.Common;
import org.cxbox.intellij.community.common.util.JavaFacade;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.TemplateContextUtil;
import org.cxbox.intellij.community.icons.PlatformIcons;
import org.cxbox.intellij.community.wigdet.fields.StandardFieldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenAddViewLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public static final PsiElementPattern.Capture<JsonStringLiteral> SCREEN_MENU_ROOT_PATTERN = Common.createPropertyNamePattern(List.of(JScreen.NAVIGATION_MENU.getName()), ".screen.json");
    public static final PsiElementPattern.Capture<JsonStringLiteral> SCREEN_CHILD_ROOT_PATTERN = Common.createPropertyNamePattern(List.of(JScreen.NAVIGATION_MENU_ANY_DEPTH_CHILD.getName()), ".screen.json");
    public static final ElementPattern<JsonStringLiteral> SCREEN_VIEW_ROOT_PATTERN = StandardPatterns.or((ElementPattern[])new ElementPattern[]{SCREEN_MENU_ROOT_PATTERN, SCREEN_CHILD_ROOT_PATTERN});

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement leaf) {
        PsiElement psiElement;
        if (leaf == null) {
            ScreenAddViewLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!(leaf instanceof LeafPsiElement) || !((psiElement = leaf.getParent()) instanceof JsonStringLiteral)) {
            return null;
        }
        JsonStringLiteral element = (JsonStringLiteral)psiElement;
        if (!SCREEN_VIEW_ROOT_PATTERN.accepts((Object)element)) {
            return null;
        }
        Icon icon = PlatformIcons.plus;
        List<TemplateContextType> allContextTypes = TemplateContextUtil.getAllTemplateContextTypes();
        TemplateContextType context = allContextTypes.stream().filter(cxt -> cxt.getContextId().equals("PlatformScreenViewsContext")).findFirst().orElse(null);
        List<TemplateImpl> frameworkTemplates = TemplateSettings.getInstance().getTemplatesAsList().stream().filter(t -> context != null && t.getTemplateContext().isEnabled(context)).toList();
        AnAction[] actions = (AnAction[])frameworkTemplates.stream().filter(template -> {
            if (SCREEN_MENU_ROOT_PATTERN.accepts((Object)element) && template.getDescription().equals(JScreen.DEFAULT_VIEW_NAME.getName())) {
                return false;
            }
            return !SCREEN_CHILD_ROOT_PATTERN.accepts((Object)element) || !template.getDescription().equals(JScreen.PRIMARY_VIEW_NAME.getName()) && !template.getDescription().equals(JScreen.PRIMARY_VIEWS.getName());
        }).map(template -> {
            if (template.getDescription().equals(JScreen.PRIMARY_VIEW_NAME.getName())) {
                JsonProperty navigation = ScreenAddViewLineMarkerProvider.getPropertyByName(element, JScreen.NAVIGATION.getName());
                if (navigation == null || ScreenAddViewLineMarkerProvider.hasProperyWithNameOnOneLevelUp((PsiElement)navigation, JScreen.PRIMARY_VIEW_NAME.getName())) {
                    return null;
                }
                return new RunTemplateAddBeforeFieldAction((Template)template, navigation, JavaFacade.getByTemplateKey(template.getKey()).map(StandardFieldType::getIcon).orElse(null));
            }
            if (template.getDescription().equals(JScreen.PRIMARY_VIEWS.getName())) {
                JsonProperty navigation = ScreenAddViewLineMarkerProvider.getPropertyByName(element, JScreen.NAVIGATION.getName());
                if (navigation == null || ScreenAddViewLineMarkerProvider.hasProperyWithNameOnOneLevelUp((PsiElement)navigation, JScreen.PRIMARY_VIEWS.getName())) {
                    return null;
                }
                return new RunTemplateAddBeforeFieldAction((Template)template, navigation, JavaFacade.getByTemplateKey(template.getKey()).map(StandardFieldType::getIcon).orElse(null));
            }
            if (template.getDescription().equals(JScreen.DEFAULT_VIEW_NAME.getName())) {
                JsonProperty child = ScreenAddViewLineMarkerProvider.getPropertyByName(element, JScreen.CHILD.getName());
                if (child == null || ScreenAddViewLineMarkerProvider.hasProperyWithNameOnOneLevelUp((PsiElement)child, JScreen.DEFAULT_VIEW_NAME.getName())) {
                    return null;
                }
                return new RunTemplateAddBeforeFieldAction((Template)template, child, JavaFacade.getByTemplateKey(template.getKey()).map(StandardFieldType::getIcon).orElse(null));
            }
            return new RunTemplateAction((Template)template, JsonFacade.getParentOfType((PsiElement)element, JsonProperty.class, true), JavaFacade.getByTemplateKey(template.getKey()).map(StandardFieldType::getIcon).orElse(null));
        }).filter(Objects::nonNull).toArray(AnAction[]::new);
        ArrayList<RunLineMarkerContributor.Info> infos = new ArrayList<RunLineMarkerContributor.Info>();
        infos.add(new RunLineMarkerContributor.Info(PlatformIcons.plus, actions, e -> "add view"));
        return RunLineMarkerInfo.createLineMarker(leaf, icon, infos);
    }

    private static JsonProperty getNavigationProperty(JsonStringLiteral element) {
        JsonProperty parent = JsonFacade.getParentOfType((PsiElement)element, JsonProperty.class);
        while (parent != null && !parent.getName().equals(JScreen.CHILD.getName())) {
            parent = JsonFacade.getParentOfType((PsiElement)parent, JsonProperty.class);
        }
        return parent;
    }

    private static JsonProperty getPropertyByName(JsonStringLiteral element, String name) {
        JsonProperty parent = JsonFacade.getParentOfType((PsiElement)element, JsonProperty.class);
        while (parent != null && !parent.getName().equals(name)) {
            parent = JsonFacade.getParentOfType((PsiElement)parent, JsonProperty.class);
        }
        return parent;
    }

    @NotNull
    private static boolean hasProperyWithNameOnOneLevelUp(@NotNull PsiElement element, @NotNull String name) {
        PsiElement parent;
        if (element == null) {
            ScreenAddViewLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ScreenAddViewLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if ((parent = element.getParent()) == null || !(parent instanceof JsonObject)) {
            return false;
        }
        JsonObject object = (JsonObject)parent;
        return Arrays.stream(object.getChildren()).map(child -> {
            JsonProperty property;
            return child instanceof JsonProperty ? (property = (JsonProperty)child) : null;
        }).map(JsonProperty::getName).anyMatch(name::equals);
    }

    @NotNull
    public String getName() {
        String string = ExecutionBundle.message((String)"run.line.marker.name", (Object[])new Object[0]);
        if (string == null) {
            ScreenAddViewLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.RunConfigurations.TestState.Run;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/screen/view/ScreenAddViewLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/screen/view/ScreenAddViewLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasProperyWithNameOnOneLevelUp";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

