/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.view.name;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.cxbox.intellij.community.common.conf.JScreen;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.jetbrains.annotations.NotNull;

public class ViewNameLineMarker
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement leaf, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (leaf == null) {
            ViewNameLineMarker.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ViewNameLineMarker.$$$reportNull$$$0(1);
        }
        if (!(leaf instanceof LeafPsiElement) || !(leaf.getParent() instanceof JsonStringLiteral)) {
            return;
        }
        PsiElement element = leaf.getParent();
        if (JView.VIEW_NAME_REF_PATTERN.accepts((Object)element)) {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return;
            }
            RelatedItemLineMarkerInfo b = NavigationGutterIconBuilder.create((Icon)AllIcons.Nodes.Weblistener).setAlignment(GutterIconRenderer.Alignment.LEFT).setTargets(NotNullLazyValue.createValue(() -> {
                JsonFile viewFile = (JsonFile)element.getContainingFile();
                JsonObject viewFileTopLevelObject = JsonFacade.getTopLevelObject(viewFile);
                JsonStringLiteral viewName = JsonFacade.safeGetPropertyValueOfType(viewFileTopLevelObject, JView.NAME);
                Project project = viewFile.getProject();
                SimpleNamedElement viewFileInjectedName = JView.getViewFileInjectedName(project, module, viewName);
                List<ImmutablePair<JsonFile, PsiElement>> allScreensByViewName = JScreen.getAllScreensByViewName(project, module, (PsiElement)viewFileInjectedName);
                return allScreensByViewName.stream().map(ImmutablePair::getRight).collect(Collectors.toList());
            })).setTooltipText("Navigate to usages").createLineMarkerInfo(leaf);
            result.add(b);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "leaf";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/view/name/ViewNameLineMarker";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

