/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.exception;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.MouseInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002B#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000eBC\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u000e\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\t\u0010\u0013J\b\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020<H\u0002R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010)\"\u0004\b.\u0010+R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00105\"\u0004\b6\u00107\u00a8\u0006="}, d2={"Lorg/cxbox/intellij/community/exception/PlatformValidationException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "text", "", "psiElement", "Lcom/intellij/psi/NavigatablePsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/NavigatablePsiElement;Lcom/intellij/openapi/project/Project;)V", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Lcom/intellij/psi/NavigatablePsiElement;Ljava/lang/Exception;Lcom/intellij/openapi/project/Project;)V", "type", "Lcom/intellij/openapi/ui/MessageType;", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Lcom/intellij/psi/NavigatablePsiElement;Ljava/lang/Exception;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/ui/MessageType;Ljavax/swing/Icon;)V", "origException", "", "getOrigException", "()Ljava/lang/Throwable;", "setOrigException", "(Ljava/lang/Throwable;)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getPsiElement", "()Lcom/intellij/psi/NavigatablePsiElement;", "setPsiElement", "(Lcom/intellij/psi/NavigatablePsiElement;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "titleColor", "getTitleColor", "setTitleColor", "getIcon", "()Ljavax/swing/Icon;", "setIcon", "(Ljavax/swing/Icon;)V", "isCustomPopup", "", "()Z", "setCustomPopup", "(Z)V", "showPopupWithLinks", "", "showPopup", "popup", "Lcom/intellij/openapi/ui/popup/Balloon;", "cxbox-intellij-plugin"})
public class PlatformValidationException
extends RuntimeException {
    @Nullable
    private Throwable origException;
    @NotNull
    private String text;
    @Nullable
    private NavigatablePsiElement psiElement;
    @NotNull
    private Project project;
    @Nullable
    private Color color;
    @Nullable
    private Color titleColor;
    @Nullable
    private Icon icon;
    private boolean isCustomPopup;

    @Nullable
    public final Throwable getOrigException() {
        return this.origException;
    }

    public final void setOrigException(@Nullable Throwable throwable) {
        this.origException = throwable;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.text = string;
    }

    @Nullable
    public final NavigatablePsiElement getPsiElement() {
        return this.psiElement;
    }

    public final void setPsiElement(@Nullable NavigatablePsiElement navigatablePsiElement) {
        this.psiElement = navigatablePsiElement;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @Nullable
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@Nullable Color color) {
        this.color = color;
    }

    @Nullable
    public final Color getTitleColor() {
        return this.titleColor;
    }

    public final void setTitleColor(@Nullable Color color) {
        this.titleColor = color;
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    public final void setIcon(@Nullable Icon icon) {
        this.icon = icon;
    }

    public final boolean isCustomPopup() {
        return this.isCustomPopup;
    }

    public final void setCustomPopup(boolean bl) {
        this.isCustomPopup = bl;
    }

    public PlatformValidationException(@NotNull String text, @Nullable NavigatablePsiElement psiElement, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.text = text;
        this.psiElement = psiElement;
        this.project = project;
        this.isCustomPopup = false;
    }

    public PlatformValidationException(@NotNull String text, @Nullable NavigatablePsiElement psiElement, @NotNull Exception e, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.text = text;
        this.psiElement = psiElement;
        this.origException = e;
        this.project = project;
        this.isCustomPopup = false;
    }

    public PlatformValidationException(@NotNull String text, @Nullable NavigatablePsiElement psiElement, @Nullable Exception e, @NotNull Project project, @NotNull MessageType type, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.text = text;
        this.psiElement = psiElement;
        this.project = project;
        this.origException = e;
        this.color = type.getPopupBackground();
        this.titleColor = type.getTitleForeground();
        this.icon = icon;
        this.isCustomPopup = true;
    }

    public void showPopupWithLinks() {
        if (!StringsKt.contains$default((CharSequence)this.text, (CharSequence)"href", (boolean)false, (int)2, null) && this.psiElement != null) {
            this.text = this.text + ". <a href=\"1\">See</a>";
        }
        Ref.ObjectRef stackTracePopup = new Ref.ObjectRef();
        if (this.origException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Throwable throwable = this.origException;
            Intrinsics.checkNotNull((Object)throwable);
            throwable.printStackTrace(pw);
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String stackTraceString = string;
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            if (!(((Object[])stackTraceElementArray).length == 0)) {
                this.text = StringsKt.trimIndent((String)(" \n                          " + this.text + "  <p>(<a href=\"stackTraceLink\">Open Stack Trace</a>)</p>"));
            }
            stackTracePopup.element = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(stackTraceString, MessageType.INFO, PlatformValidationException::showPopupWithLinks$lambda$0).setHideOnLinkClick(true).createBalloon();
        }
        if (this.isCustomPopup) {
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.text, this.icon, this.titleColor, this.color, arg_0 -> PlatformValidationException.showPopupWithLinks$lambda$1(this, stackTracePopup, arg_0)).setHideOnLinkClick(true).createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
            popup = balloon;
            this.showPopup(popup);
        } else {
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.text, MessageType.INFO, arg_0 -> PlatformValidationException.showPopupWithLinks$lambda$2(this, stackTracePopup, arg_0)).setHideOnLinkClick(true).createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
            popup = balloon;
            this.showPopup(popup);
        }
    }

    private final void showPopup(Balloon popup) {
        if (MouseInfo.getPointerInfo().getLocation() != null) {
            popup.show(new RelativePoint(MouseInfo.getPointerInfo().getLocation()), Balloon.Position.atRight);
        }
        JFrame jFrame = WindowManager.getInstance().getFrame(this.project);
        popup.showInCenterOf((JComponent)(jFrame != null ? jFrame.getRootPane() : null));
    }

    private static final void showPopupWithLinks$lambda$0(HyperlinkEvent e) {
    }

    private static final void showPopupWithLinks$lambda$1(PlatformValidationException this$0, Ref.ObjectRef $stackTracePopup, HyperlinkEvent e) {
        block0: {
            block1: {
                if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) break block0;
                if (!Intrinsics.areEqual((Object)e.getDescription(), (Object)"stackTraceLink")) break block1;
                Object object = $stackTracePopup.element;
                Intrinsics.checkNotNull((Object)object);
                this$0.showPopup((Balloon)object);
                break block0;
            }
            NavigatablePsiElement navigatablePsiElement = this$0.psiElement;
            if (navigatablePsiElement == null) break block0;
            navigatablePsiElement.navigate(true);
        }
    }

    private static final void showPopupWithLinks$lambda$2(PlatformValidationException this$0, Ref.ObjectRef $stackTracePopup, HyperlinkEvent e) {
        block0: {
            block1: {
                if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) break block0;
                if (!Intrinsics.areEqual((Object)e.getDescription(), (Object)"stackTraceLink")) break block1;
                Object object = $stackTracePopup.element;
                Intrinsics.checkNotNull((Object)object);
                this$0.showPopup((Balloon)object);
                break block0;
            }
            NavigatablePsiElement navigatablePsiElement = this$0.psiElement;
            if (navigatablePsiElement == null) break block0;
            navigatablePsiElement.navigate(true);
        }
    }
}

