/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.FormattingService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormattingServiceUtil {
    private static final Logger LOG = Logger.getInstance(FormattingServiceUtil.class);

    private FormattingServiceUtil() {
    }

    @NotNull
    public static FormattingService findService(@NotNull PsiFile file, boolean isExplicit, boolean isCompleteFile) {
        FormattingService formattingService;
        if (file == null) {
            FormattingServiceUtil.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((formattingService = (FormattingService)ContainerUtil.find((Iterable)FormattingService.EP_NAME.getExtensionList(), s -> !(!s.canFormat(file) || !isExplicit && !s.getFeatures().contains(FormattingService.Feature.AD_HOC_FORMATTING) || !isCompleteFile && !s.getFeatures().contains(FormattingService.Feature.FORMAT_FRAGMENTS)))) != null, (Object)("At least 1 formatting service which can handle PsiFile " + file.getName() + " should be registered."));
        FormattingService formattingService2 = formattingService;
        if (formattingService2 == null) {
            FormattingServiceUtil.$$$reportNull$$$0(1);
        }
        return formattingService2;
    }

    @Nullable
    public static FormattingService findService(Class<? extends FormattingService> serviceClass) {
        return (FormattingService)ContainerUtil.find((Iterable)FormattingService.EP_NAME.getExtensionList(), s -> s.getClass().equals(serviceClass));
    }

    @NotNull
    public static FormattingService findImportsOptimizingService(@NotNull PsiFile file) {
        FormattingService importsOptimizer;
        if (file == null) {
            FormattingServiceUtil.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((importsOptimizer = (FormattingService)ContainerUtil.find((Iterable)FormattingService.EP_NAME.getExtensionList(), s -> s.canFormat(file) && s.getFeatures().contains(FormattingService.Feature.OPTIMIZE_IMPORTS))) != null, (Object)("At least 1 formatting service which can optimize imports in PsiFile " + file.getName() + " should be registered."));
        FormattingService formattingService = importsOptimizer;
        if (formattingService == null) {
            FormattingServiceUtil.$$$reportNull$$$0(3);
        }
        return formattingService;
    }

    private static List<FormattingService> getChainedServices(@NotNull FormattingService formattingService) {
        if (formattingService == null) {
            FormattingServiceUtil.$$$reportNull$$$0(4);
        }
        ArrayList<FormattingService> serviceList = new ArrayList<FormattingService>();
        FormattingService currService = formattingService;
        while (currService != null && !serviceList.contains(currService)) {
            serviceList.add(0, currService);
            currService = (FormattingService)ObjectUtils.doIfNotNull((Object)currService.runAfter(), FormattingServiceUtil::findService);
        }
        return serviceList;
    }

    @NotNull
    public static PsiElement formatElement(@NotNull PsiElement element, boolean canChangeWhiteSpaceOnly) {
        if (element == null) {
            FormattingServiceUtil.$$$reportNull$$$0(5);
        }
        PsiFile file = element.getContainingFile();
        PsiElement contextElement = element;
        FormattingService mainService = FormattingServiceUtil.findService(file, true, element.getTextRange().equals((Object)file.getTextRange()));
        for (FormattingService service : FormattingServiceUtil.getChainedServices(mainService)) {
            contextElement = service.formatElement(contextElement, canChangeWhiteSpaceOnly);
        }
        PsiElement psiElement = contextElement;
        if (psiElement == null) {
            FormattingServiceUtil.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement formatElement(@NotNull PsiElement element, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly) {
        if (element == null) {
            FormattingServiceUtil.$$$reportNull$$$0(7);
        }
        if (range == null) {
            FormattingServiceUtil.$$$reportNull$$$0(8);
        }
        PsiFile file = element.getContainingFile();
        boolean isFullRange = range.equals((Object)file.getTextRange());
        PsiElement contextElement = element;
        FormattingService mainService = FormattingServiceUtil.findService(element.getContainingFile(), true, isFullRange);
        if (isFullRange) {
            for (FormattingService service : FormattingServiceUtil.getChainedServices(mainService)) {
                contextElement = service.formatElement(contextElement, range, canChangeWhiteSpacesOnly);
            }
            PsiElement psiElement = contextElement;
            if (psiElement == null) {
                FormattingServiceUtil.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        PsiElement psiElement = mainService.formatElement(element, range, canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            FormattingServiceUtil.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    public static void formatRanges(@NotNull PsiFile file, @NotNull FormatTextRanges ranges, boolean canChangeWhiteSpaceOnly) {
        if (file == null) {
            FormattingServiceUtil.$$$reportNull$$$0(11);
        }
        if (ranges == null) {
            FormattingServiceUtil.$$$reportNull$$$0(12);
        }
        boolean isFullRange = ranges.getRanges().size() == 1 && ((FormatTextRange)ranges.getRanges().get(0)).getTextRange().equals((Object)file.getTextRange());
        FormattingService mainService = FormattingServiceUtil.findService(file, true, isFullRange);
        if (isFullRange) {
            for (FormattingService service : FormattingServiceUtil.getChainedServices(mainService)) {
                service.formatRanges(file, (FormattingRangesInfo)ranges, canChangeWhiteSpaceOnly, false);
            }
        } else {
            mainService.formatRanges(file, (FormattingRangesInfo)ranges, canChangeWhiteSpaceOnly, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/FormattingServiceUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingService";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/FormattingServiceUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findImportsOptimizingService";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findImportsOptimizingService";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChainedServices";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatRanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 9, 10 -> new IllegalStateException(string);
        };
    }
}

