/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import java.util.List;
import org.cxbox.intellij.community.common.Cache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseEntityUtil {
    public static void addFieldWithAnnotaionToEntity(@NotNull Project project, @NotNull Module module, PsiClass entityPsiClass, @Nullable String fieldName, @Nullable PsiType entityFieldTypeByName, @Nullable String columnAnnotation, @NotNull List<String> entityAnnotationTextList) {
        if (project == null) {
            BaseEntityUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            BaseEntityUtil.$$$reportNull$$$0(1);
        }
        if (entityAnnotationTextList == null) {
            BaseEntityUtil.$$$reportNull$$$0(2);
        }
        if (fieldName != null && entityFieldTypeByName != null) {
            Module newModule = ModuleUtil.findModuleForPsiElement((PsiElement)entityPsiClass);
            JavaCodeStyleManager instance = JavaCodeStyleManager.getInstance((Project)entityPsiClass.getProject());
            PsiElementFactory entityElementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiField entityField = entityElementFactory.createField(fieldName, entityFieldTypeByName);
            PsiAnnotation annotationFromText = entityElementFactory.createAnnotationFromText((String)(columnAnnotation != null ? columnAnnotation : "@" + Cache.getPersistenceVersionWithoutDot(project, newModule) + ".Column"), (PsiElement)entityPsiClass);
            PsiField alreadyExistingEntityField = entityPsiClass.findFieldByName(fieldName, true);
            if (alreadyExistingEntityField == null) {
                PsiField entityPsiClassField = (PsiField)entityPsiClass.add((PsiElement)entityField);
                PsiModifierList modifierList = entityPsiClassField.getModifierList();
                if (modifierList != null && !entityAnnotationTextList.isEmpty()) {
                    for (String entityAnnotationText : entityAnnotationTextList) {
                        PsiAnnotation entityAnnotationTextFromText = entityElementFactory.createAnnotationFromText(entityAnnotationText, (PsiElement)entityPsiClass);
                        PsiElement annotationPsiElement = modifierList.addAfter((PsiElement)entityAnnotationTextFromText, null);
                        instance.shortenClassReferences(annotationPsiElement);
                    }
                }
                if (modifierList != null) {
                    PsiElement newAnnotation = modifierList.addAfter((PsiElement)annotationFromText, null);
                    instance.shortenClassReferences(newAnnotation);
                }
                instance.shortenClassReferences((PsiElement)entityPsiClassField);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)entityPsiClass.getContainingFile());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "entityAnnotationTextList";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/common/util/BaseEntityUtil";
        objectArray[2] = "addFieldWithAnnotaionToEntity";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

